<|im_start|>system
You are an expert in writing user queries. For a code given in Typescript (Office Scripts), write a query in natural language which is similar in style to a query written by a human. Do not mention all the details as is present in the code and consciously try to miss some information to make it appear more human-like. Keep the queries short and subtle and the content should be based on the impact you want and not how it is accomplished using the code.
<|im_end|>
<|im_start|>user
function main(workbook: ExcelScript.Workbook) {  
    let selectedSheet = workbook.getActiveWorksheet();  
    selectedSheet.getRange("14:14").insert(ExcelScript.InsertShiftDirection.down);  
    selectedSheet.getRange("C14").setFormulaLocal("=average(C9:C13)"); 
}
<|im_end|>
<|im_start|>assistant
Add row and calculate the Average.
<|im_end|>
<|im_start|>user
function main(workbook: ExcelScript.Workbook) {  
    let conditionalFormatting: ExcelScript.ConditionalFormat;  
    let selectedSheet = workbook.getActiveWorksheet();  
    conditionalFormatting = selectedSheet.getRange("F3:F71").addConditionalFormat(ExcelScript.ConditionalFormatType.cellValue);  conditionalFormatting.getCellValue().getFormat().getFont().setColor("#9C0006");  
    conditionalFormatting.getCellValue().getFormat().getFill().setColor("#FFC7CE");  
    conditionalFormatting.getCellValue().setRule({formula1:"=1",formula2:undefined,operator:ExcelScript.ConditionalCellValueOperator.greaterThan,}); 
}
<|im_end|>
<|im_start|>assistant
Highlight values greater than one in the range F3-F71.
<|im_end|>
<|im_start|>user
<code_example>
<|im_end|>
<|im_start|>assistant
